<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl">Data Barang</h2>
    </x-slot>

    <div class="p-6">

        <a href="{{ route('barang.create') }}"
           class="mb-4 inline-block px-4 py-2 bg-blue-600 text-white rounded">
            + Tambah Barang
        </a>

        @if(session('success'))
            <div class="mb-4 p-3 bg-green-600 text-white rounded">
                {{ session('success') }}
            </div>
        @endif

        <div class="space-y-4">
            @foreach($barang as $item)
                <div class="p-4 bg-white dark:bg-gray-800 rounded shadow">
                    <div class="font-semibold">{{ $item->nama_barang }}</div>
                    <div>Harga: Rp {{ number_format($item->harga,0,',','.') }}</div>
                    <div>Satuan: {{ $item->satuan }}</div>

                    <div class="mt-3 flex gap-2">
                        <a href="{{ route('barang.edit', $item) }}"
                           class="px-3 py-1 bg-yellow-500 text-white rounded">
                            Edit
                        </a>

                        <form method="POST" action="{{ route('barang.destroy', $item) }}">
                            @csrf
                            @method('DELETE')
                            <button
                                onclick="return confirm('Hapus barang ini?')"
                                class="px-3 py-1 bg-red-600 text-white rounded">
                                Hapus
                            </button>
                        </form>
                    </div>
                </div>
            @endforeach
        </div>

    </div>
</x-app-layout>
