<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>
        @hasSection('title')
            @yield('title') – {{ config('app.name', 'Aplikasi') }}
        @else
            {{ config('app.name', 'Aplikasi') }}
        @endif
    </title>

    <!-- Dark Mode Init -->
    <script>
        document.documentElement.classList.remove('dark');
        localStorage.theme = 'light';
    </script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="font-sans antialiased relative overflow-x-hidden">
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900">

        @include('layouts.navigation')

        @isset($header)
            <header
                class="sticky top-0 z-40
           bg-white/80 dark:bg-gray-800/80
           backdrop-blur-md
           border-b border-gray-200/70 dark:border-gray-700
           transition-all duration-300">

                <div class="max-w-7xl mx-auto py-4 px-4 sm:px-6 lg:px-8">
                    {{ $header }}
                </div>
            </header>
        @endisset

        <main class="pb-28 md:pb-0">
            {{ $slot }}
        </main>

    </div>

    <x-mobile-bottom-nav />
</body>

</html>
