@section('title', 'Tambah Penjualan')

<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold">Tambah Penjualan</h2>
    </x-slot>

    <div class="p-4 max-w-xl mx-auto" x-data="penjualanForm({{ $barang->toJson() }})">

        <form method="POST" action="{{ route('penjualan.store') }}" class="space-y-6">
            @csrf

            {{-- ===================== --}}
            {{-- SECTION 1: INFO --}}
            {{-- ===================== --}}
            <div class="bg-white rounded-xl shadow border p-4 space-y-3">
                <h3 class="font-semibold text-gray-800 text-sm">
                    1️⃣ Informasi Penjualan
                </h3>

                <div>
                    <label class="block text-xs text-gray-500 mb-1">
                        Nama Customer
                    </label>
                    <input type="text" name="customer_name" placeholder="Contoh: Budi / Toko Sumber Rejeki"
                        class="w-full rounded border-gray-300" required>
                </div>

                <div>
                    <label class="block text-xs text-gray-500 mb-1">
                        Tanggal Transaksi
                    </label>
                    <input type="date" name="tanggal" value="{{ date('Y-m-d') }}"
                        class="w-full rounded border-gray-300" required>
                </div>
            </div>

            {{-- ===================== --}}
            {{-- SECTION 2: ITEMS --}}
            {{-- ===================== --}}
            <div class="bg-white rounded-xl shadow border p-4 space-y-4">
                <h3 class="font-semibold text-gray-800 text-sm">
                    2️⃣ Daftar Barang
                </h3>

                <template x-for="(item, index) in items" :key="index">
                    <div class="p-3 rounded-lg bg-gray-50 border space-y-2">

                        <select x-model="item.barang_id" @change="updateItem(item)" :name="`items[${index}][barang_id]`"
                            class="w-full rounded">
                            <option value="">— Pilih Barang —</option>
                            <template x-for="b in barang" :key="b.id">
                                <option :value="b.id" x-text="b.nama_barang"></option>
                            </template>
                        </select>

                        <div class="flex items-center gap-3">
                            <input type="number" min="1" x-model.number="item.qty" @input="updateItem(item)"
                                :name="`items[${index}][qty]`" class="w-24 rounded" placeholder="Qty">

                            <span class="text-sm font-semibold text-gray-700">
                                Rp <span x-text="formatRupiah(item.subtotal)"></span>
                            </span>
                        </div>

                        <button type="button" @click="removeItem(index)" class="text-xs text-red-500">
                            Hapus barang
                        </button>
                    </div>
                </template>

                <button type="button" @click="addItem()"
                    class="w-full py-2 border border-dashed rounded-lg text-sm text-gray-600">
                    + Tambah Barang
                </button>
            </div>

            {{-- ===================== --}}
            {{-- SECTION 3: TOTAL --}}
            {{-- ===================== --}}
            <div class="bg-green-50 border border-green-200 rounded-xl p-4">
                <div class="text-xs text-green-700 mb-1">
                    Total Pembayaran
                </div>
                <div class="text-2xl font-bold text-green-800">
                    Rp <span x-text="formatRupiah(total)"></span>
                </div>
            </div>

            {{-- ===================== --}}
            {{-- SECTION 4: ACTION --}}
            {{-- ===================== --}}
            <div class="space-y-2 pt-2">

                {{-- HELPER TEXT --}}
                <div x-show="!canSubmit" class="text-xs text-red-600 text-center">
                    Tambahkan minimal 1 barang dengan qty valid
                </div>

                <div class="grid grid-cols-2 gap-3">
                    <a href="{{ route('penjualan.index') }}"
                        class="py-3 text-center bg-gray-200 rounded-lg font-semibold text-gray-700">
                        Kembali ke Daftar
                    </a>

                    <button type="submit" :disabled="!canSubmit"
                        :class="canSubmit
                            ?
                            'bg-blue-600 hover:bg-blue-700' :
                            'bg-blue-300 cursor-not-allowed'"
                        class="py-3 text-white rounded-lg font-semibold transition">
                        Simpan Penjualan
                    </button>
                </div>
            </div>
        </form>
    </div>

    {{-- SCRIPT --}}
    <script>
        function penjualanForm(barang) {
            return {
                barang,
                items: [{
                    barang_id: '',
                    qty: 1,
                    harga: 0,
                    subtotal: 0
                }],

                addItem() {
                    this.items.push({
                        barang_id: '',
                        qty: 1,
                        harga: 0,
                        subtotal: 0
                    });
                },

                removeItem(index) {
                    this.items.splice(index, 1);
                },

                updateItem(item) {
                    const selected = this.barang.find(b => b.id == item.barang_id);
                    item.harga = selected ? selected.harga : 0;
                    item.subtotal = item.qty * item.harga;
                },

                get total() {
                    return this.items.reduce((sum, i) => sum + i.subtotal, 0);
                },

                get canSubmit() {
                    if (this.total <= 0) return false;

                    return this.items.some(i =>
                        i.barang_id && i.qty > 0 && i.subtotal > 0
                    );
                },

                formatRupiah(v) {
                    return new Intl.NumberFormat('id-ID').format(v || 0);
                }
            }
        }
    </script>
</x-app-layout>
