@section('title', 'Edit Penjualan')

<x-app-layout>
    {{-- ===================== --}}
    {{-- HEADER --}}
    {{-- ===================== --}}
    <x-slot name="header">
        <h2 class="text-xl font-semibold">
            Edit Penjualan
        </h2>
    </x-slot>

    {{-- ===================== --}}
    {{-- CONTENT --}}
    {{-- ===================== --}}
    <div
        class="p-4 max-w-xl mx-auto space-y-6"
        x-data="editPenjualan(
            {{ $barang->toJson() }},
            {{ $penjualan->details->map(fn($d) => [
                'barang_id' => (int) $d->barang_id,
                'qty' => (int) $d->qty,
            ])->toJson() }}
        )"
        x-init="init()"
    >

        <form method="POST" action="{{ route('penjualan.update', $penjualan) }}" class="space-y-6">
            @csrf
            @method('PUT')

            {{-- ===================== --}}
            {{-- SECTION 1: INFO --}}
            {{-- ===================== --}}
            <div class="bg-white rounded-xl shadow border p-4 space-y-3">
                <h3 class="text-sm font-semibold text-gray-700">
                    1️⃣ Informasi Penjualan
                </h3>

                <div>
                    <label class="block text-xs text-gray-500 mb-1">
                        Tanggal Transaksi
                    </label>
                    <input
                        type="date"
                        name="tanggal"
                        value="{{ $penjualan->tanggal }}"
                        class="w-full rounded border-gray-300"
                        required
                    >
                </div>
            </div>

            {{-- ===================== --}}
            {{-- SECTION 2: ITEMS --}}
            {{-- ===================== --}}
            <div class="bg-white rounded-xl shadow border p-4 space-y-4">
                <h3 class="text-sm font-semibold text-gray-700">
                    2️⃣ Daftar Barang
                </h3>

                <template x-for="(item, index) in items" :key="'item-' + index">
                    <div class="p-3 rounded-lg bg-gray-50 border space-y-3">

                        {{-- BARANG --}}
                        <div>
                            <label class="block text-xs text-gray-500 mb-1">
                                Barang
                            </label>
                            <select
                                :name="`items[${index}][barang_id]`"
                                @change="onBarangChange(item, $event.target.value)"
                                class="w-full rounded border-gray-300"
                                required
                            >
                                <option value="">— Pilih Barang —</option>
                                <template x-for="b in barang" :key="b.id">
                                    <option
                                        :value="b.id"
                                        :selected="Number(b.id) === Number(item.barang_id)"
                                        x-text="b.nama_barang">
                                    </option>
                                </template>
                            </select>
                        </div>

                        {{-- QTY + SUBTOTAL --}}
                        <div class="flex items-center justify-between gap-3">
                            <input
                                type="number"
                                min="1"
                                :name="`items[${index}][qty]`"
                                :value="item.qty"
                                @input="onQtyChange(item, $event.target.value)"
                                :disabled="!item.barang_id"
                                class="w-24 rounded border-gray-300 disabled:opacity-50"
                                placeholder="Qty"
                            >

                            <div
                                class="text-sm font-semibold text-gray-700"
                                x-show="item.subtotal > 0"
                            >
                                Rp <span x-text="formatRupiah(item.subtotal)"></span>
                            </div>
                        </div>

                        {{-- REMOVE --}}
                        <button
                            type="button"
                            @click="removeItem(index)"
                            :disabled="items.length === 1"
                            class="text-xs text-red-500 disabled:opacity-50"
                        >
                            Hapus barang
                        </button>
                    </div>
                </template>

                {{-- ADD ITEM --}}
                <button
                    type="button"
                    @click="addItem()"
                    class="w-full py-2 border border-dashed rounded-lg text-sm text-gray-600"
                >
                    + Tambah Barang
                </button>
            </div>

            {{-- ===================== --}}
            {{-- SECTION 3: TOTAL --}}
            {{-- ===================== --}}
            <div class="bg-green-50 border border-green-200 rounded-xl p-4">
                <div class="text-xs text-green-700 mb-1">
                    Total Pembayaran
                </div>
                <div class="text-2xl font-bold text-green-800">
                    Rp <span x-text="formatRupiah(total)"></span>
                </div>
            </div>

            {{-- ===================== --}}
            {{-- SECTION 4: ACTION --}}
            {{-- ===================== --}}
            <div class="grid grid-cols-2 gap-3 pt-2">
                <a
                    href="{{ route('penjualan.index') }}"
                    class="py-3 text-center bg-gray-200 rounded-lg font-semibold"
                >
                    Batal
                </a>

                <button
                    type="submit"
                    class="py-3 bg-blue-600 text-white rounded-lg font-semibold"
                >
                    Update Penjualan
                </button>
            </div>
        </form>
    </div>

    {{-- ===================== --}}
    {{-- ALPINE SCRIPT --}}
    {{-- ===================== --}}
    <script>
        function editPenjualan(barang, existingItems) {
            return {
                barang: [],
                items: [],

                init() {
                    this.barang = barang.map(b => ({
                        ...b,
                        id: Number(b.id),
                        harga: Number(b.harga)
                    }));

                    this.items = existingItems.map(i => {
                        const barangId = Number(i.barang_id);
                        const selected = this.barang.find(b => b.id === barangId);
                        const harga = selected ? selected.harga : 0;
                        const qty = Number(i.qty) || 1;

                        return {
                            barang_id: barangId,
                            qty: qty,
                            harga: harga,
                            subtotal: qty * harga
                        };
                    });
                },

                addItem() {
                    this.items.push({
                        barang_id: '',
                        qty: 1,
                        harga: 0,
                        subtotal: 0
                    });
                },

                removeItem(index) {
                    if (this.items.length > 1) {
                        this.items.splice(index, 1);
                    }
                },

                onBarangChange(item, value) {
                    item.barang_id = Number(value);
                    const selected = this.barang.find(b => b.id === item.barang_id);

                    if (selected) {
                        item.harga = selected.harga;
                        item.qty = Number(item.qty) || 1;
                        item.subtotal = item.qty * item.harga;
                    } else {
                        item.harga = 0;
                        item.subtotal = 0;
                    }
                },

                onQtyChange(item, value) {
                    item.qty = Number(value) || 0;
                    item.subtotal = item.qty * item.harga;
                },

                get total() {
                    return this.items.reduce((sum, i) => sum + (i.subtotal || 0), 0);
                },

                formatRupiah(value) {
                    return new Intl.NumberFormat('id-ID').format(value || 0);
                }
            }
        }
    </script>
</x-app-layout>
