@section('title', 'Data Penjualan')

<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-bold">Data Penjualan Kering Kentang</h2>
        </div>
    </x-slot>

    @if (session('success'))
        <div x-data="{ show: true }" x-init="setTimeout(() => show = false, 3000)" x-show="show" x-transition
            class="fixed top-6 right-6 z-50
               bg-green-600 text-white
               px-5 py-3 rounded-lg shadow-xl
               flex items-center gap-3">

            <!-- Icon -->
            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24"
                stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
            </svg>

            <span class="text-sm font-semibold">
                {{ session('success') }}
            </span>
        </div>
    @endif

    {{-- ===================== --}}
    {{-- SUMMARY (RESPONSIVE & MODERN) --}}
    {{-- ===================== --}}
    <div class="px-4 md:px-6 mt-4">

        <div class="bg-white rounded-2xl shadow border p-4 md:p-6 space-y-4">

            {{-- TITLE --}}
            <h3 class="text-sm font-semibold text-gray-700">
                Ringkasan Penjualan
            </h3>

            {{-- GRID WRAPPER --}}
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">

                {{-- TOTAL --}}
                <div
                    class="md:col-span-1 bg-gradient-to-br from-green-600 to-green-500
           text-white rounded-xl p-5
           flex flex-col justify-between gap-4">

                    {{-- TOP --}}
                    <div>
                        <div class="text-xs opacity-90">
                            Total Keseluruhan
                        </div>

                        <div class="text-2xl md:text-3xl font-bold mt-1">
                            Rp {{ number_format($totalKeseluruhan, 0, ',', '.') }}
                        </div>
                    </div>

                    {{-- STATS --}}
                    <div class="flex items-center justify-between
                bg-white/15 rounded-lg px-3 py-2">

                        {{-- QTY --}}
                        <div class="flex items-center gap-2">
                            <span class="text-lg">🫙</span>
                            <div>
                                <div class="text-xs opacity-90">
                                    Total Terjual
                                </div>
                                <div class="text-sm font-semibold">
                                    {{ number_format($totalQty) }} Toples
                                </div>
                            </div>
                        </div>

                        {{-- LABEL --}}
                        <div class="text-[10px] opacity-80 text-right leading-tight">
                            Akumulasi<br>seluruh transaksi
                        </div>
                    </div>
                </div>


                {{-- MONTHLY --}}
                <div class="md:col-span-2">

                    {{-- MOBILE: HORIZONTAL SCROLL --}}
                    <div class="flex md:hidden gap-3 overflow-x-auto pb-2 -mx-1 px-1">
                        @foreach ($summaryBulanan->take(6) as $s)
                            <div class="min-w-[160px] bg-gray-50 border rounded-xl p-4 shrink-0">
                                <div class="text-[11px] font-semibold text-gray-500 uppercase">
                                    {{ \Carbon\Carbon::createFromFormat('Y-m', $s->bulan)->translatedFormat('M Y') }}
                                </div>
                                <div class="text-xs text-gray-500 mt-1">
                                    {{ $s->total_transaksi }} trx
                                </div>
                                <div class="text-sm font-bold text-blue-600 mt-1">
                                    Rp {{ number_format($s->total_nominal, 0, ',', '.') }}
                                </div>
                            </div>
                        @endforeach
                    </div>

                    {{-- DESKTOP: GRID --}}
                    <div class="hidden md:grid grid-cols-2 gap-3">
                        @foreach ($summaryBulanan->take(4) as $s)
                            <div class="bg-gray-50 border rounded-xl p-4">
                                <div class="text-xs font-semibold text-gray-500 uppercase">
                                    {{ \Carbon\Carbon::createFromFormat('Y-m', $s->bulan)->translatedFormat('F Y') }}
                                </div>
                                <div class="text-xs text-gray-500 mt-1">
                                    {{ $s->total_transaksi }} Transaksi
                                </div>
                                <div class="text-lg font-bold text-blue-600 mt-1">
                                    Rp {{ number_format($s->total_nominal, 0, ',', '.') }}
                                </div>
                            </div>
                        @endforeach
                    </div>

                </div>
            </div>

        </div>
    </div>

    {{-- ===================== --}}
    {{-- SEARCH FILTER --}}
    {{-- ===================== --}}
    <form method="GET" x-data="searchForm()" @submit="beforeSubmit" class="px-4 md:px-6 mt-4">
        <div class="bg-white rounded-xl shadow border p-4 grid grid-cols-1 md:grid-cols-4 gap-3">

            <input type="text" name="customer" value="{{ request('customer') }}" placeholder="Cari nama pelanggan..."
                class="rounded border-gray-300">

            <input type="date" name="tanggal" value="{{ request('tanggal') }}" class="rounded border-gray-300">

            <button class="bg-blue-600 text-white rounded-lg px-4 py-2">
                Cari
            </button>

            <a href="{{ route('penjualan.index') }}" class="text-center bg-gray-200 rounded-lg px-4 py-2">
                Reset
            </a>
        </div>
    </form>


    {{-- ===================== --}}
    {{-- MOBILE VIEW --}}
    {{-- ===================== --}}
    <div class="block md:hidden pb-4 p-4 max-w-xl mx-auto space-y-4">
        @php $currentMonth = null; @endphp

        @forelse ($penjualan as $p)
            @php
                $monthLabel = \Carbon\Carbon::parse($p->tanggal)->translatedFormat('F Y');
            @endphp

            {{-- BULAN HEADER --}}
            @if ($monthLabel !== $currentMonth)
                <div class="pt-4 pb-1">
                    <h3 class="text-sm font-bold text-gray-500 uppercase">
                        {{ $monthLabel }}
                    </h3>
                </div>
                @php $currentMonth = $monthLabel; @endphp
            @endif

            {{-- CARD --}}
            <div class="bg-white rounded-xl shadow border p-4 space-y-3">

                {{-- Header --}}
                <div class="flex justify-between items-start gap-2">
                    <div class="min-w-0">
                        {{-- CUSTOMER --}}
                        <div class="font-semibold text-gray-900 text-sm truncate">
                            {{ $p->customer_name ?? '-' }}
                        </div>

                        {{-- INVOICE --}}
                        <div class="text-xs text-gray-500 truncate">
                            {{ $p->invoice }}
                        </div>

                        {{-- TANGGAL --}}
                        <div class="text-xs text-gray-400 mt-0.5">
                            {{ \Carbon\Carbon::parse($p->tanggal)->translatedFormat('d M Y') }}
                        </div>
                    </div>

                    {{-- STATUS (MOBILE INTERACTIVE) --}}
                    <form action="{{ route('penjualan.updateStatus', $p) }}" method="POST">
                        @csrf
                        @method('PATCH')

                        <label class="sr-only">Status Penjualan</label>

                        <select name="status" onchange="this.form.submit()"
                            class="appearance-none
                            flex items-center gap-1
                            text-xs font-semibold
                            px-3 py-1.5 rounded-full
                            cursor-pointer
                            focus:outline-none focus:ring-2 focus:ring-offset-1
                            @if ($p->status === 'draft') bg-gray-100 text-gray-700 focus:ring-gray-400
                            @elseif ($p->status === 'menunggu_pembayaran')
                                bg-amber-100 text-amber-700 focus:ring-amber-400
                            @elseif ($p->status === 'diproses')
                                bg-blue-100 text-blue-700 focus:ring-blue-400 @endif">

                            <option value="draft" @selected($p->status === 'draft')>
                                📝 Draft
                            </option>

                            <option value="menunggu_pembayaran" @selected($p->status === 'menunggu_pembayaran')>
                                ⏳ Unpaid
                            </option>

                            <option value="diproses" @selected($p->status === 'diproses')>
                                🔄 Diproses
                            </option>
                        </select>
                    </form>

                </div>

                {{-- Total --}}
                <div class="pt-2 border-t">
                    <div class="text-xs text-gray-500">Total Pembayaran</div>
                    <div class="text-lg font-bold text-blue-600">
                        Rp {{ number_format($p->total_harga, 0, ',', '.') }}
                    </div>
                </div>

                {{-- Actions --}}
                <div class="grid grid-cols-3 gap-2 pt-2">
                    <a href="{{ route('penjualan.show', $p) }}"
                        class="py-2 bg-blue-600 text-white rounded-lg text-xs text-center">
                        Detail
                    </a>

                    <a href="{{ route('penjualan.edit', $p) }}"
                        class="py-2 bg-amber-500 text-white rounded-lg text-xs text-center">
                        Edit
                    </a>

                    <form action="{{ route('penjualan.destroy', $p) }}" method="POST"
                        onsubmit="return confirm('Yakin hapus penjualan ini?')">
                        @csrf
                        @method('DELETE')
                        <button class="w-full py-2 bg-red-600 text-white rounded-lg text-xs">
                            Hapus
                        </button>
                    </form>
                </div>
            </div>
        @empty
            <div class="text-center text-gray-500 py-10">
                <div class="text-sm font-semibold">Belum ada penjualan</div>
                <div class="text-xs mt-1">
                    Silakan tambah penjualan baru
                </div>
            </div>
        @endforelse

        {{-- MOBILE PAGINATION --}}
        <div class="flex items-center justify-between gap-4 pt-4">
            {{-- Previous --}}
            @if ($penjualan->onFirstPage())
                <span class="flex-1 py-3 text-center text-sm rounded-lg bg-gray-100 text-gray-400">
                    ← Sebelumnya
                </span>
            @else
                <a href="{{ $penjualan->previousPageUrl() }}"
                    class="flex-1 py-3 text-center text-sm rounded-lg bg-blue-600 text-white font-semibold">
                    ← Sebelumnya
                </a>
            @endif

            {{-- Next --}}
            @if ($penjualan->hasMorePages())
                <a href="{{ $penjualan->nextPageUrl() }}"
                    class="flex-1 py-3 text-center text-sm rounded-lg bg-blue-600 text-white font-semibold">
                    Berikutnya →
                </a>
            @else
                <span class="flex-1 py-3 text-center text-sm rounded-lg bg-gray-100 text-gray-400">
                    Berikutnya →
                </span>
            @endif
        </div>

        {{-- PAGE INFO --}}
        <div class="text-center text-xs text-gray-500 mt-2">
            Halaman {{ $penjualan->currentPage() }} dari {{ $penjualan->lastPage() }}
        </div>

    </div>

    {{-- ===================== --}}
    {{-- DESKTOP VIEW --}}
    {{-- ===================== --}}
    <div class="hidden md:block p-6 space-y-3">

        {{-- TABLE HEADER --}}
        <div class="flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800">
                Daftar Penjualan
            </h3>

            <a href="{{ route('penjualan.create') }}"
                class="inline-flex items-center gap-2
                   px-4 py-2 bg-blue-600 text-white
                   rounded-lg text-sm font-semibold
                   hover:bg-blue-700 transition">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                </svg>
                Tambah Penjualan
            </a>
        </div>

        {{-- TABLE --}}
        <div class="bg-white rounded-xl shadow border overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead class="bg-gray-100 text-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left">Invoice</th>
                        <th class="px-4 py-3 text-left">Customer</th>
                        <th class="px-4 py-3 text-left">Tanggal</th>
                        <th class="px-4 py-3 text-left">Status</th>
                        <th class="px-4 py-3 text-right">Total</th>
                        <th class="px-4 py-3 text-center">Aksi</th>
                    </tr>
                </thead>

                <tbody class="divide-y">
                    @foreach ($penjualan as $p)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 font-semibold">
                                {{ $p->invoice }}
                            </td>

                            <td class="px-4 py-3">
                                <div class="font-semibold text-gray-900">
                                    {{ $p->customer_name ?? '-' }}
                                </div>
                                <div class="text-xs text-gray-500">
                                    {{ $p->invoice }}
                                </div>
                            </td>

                            <td class="px-4 py-3">
                                {{ \Carbon\Carbon::parse($p->tanggal)->translatedFormat('d M Y') }}
                            </td>

                            <td class="px-4 py-3">
                                <form action="{{ route('penjualan.updateStatus', $p) }}" method="POST">
                                    @csrf
                                    @method('PATCH')

                                    <select name="status" onchange="this.form.submit()"
                                        class="text-xs font-semibold rounded-full px-3 py-1
                                        border-0 focus:ring-2 focus:ring-blue-500
                                        cursor-pointer
                                        @if ($p->status === 'draft') bg-gray-100 text-gray-700
                                        @elseif ($p->status === 'menunggu_pembayaran') bg-amber-100 text-amber-700
                                        @elseif ($p->status === 'diproses') bg-blue-100 text-blue-700 @endif">

                                        <option value="draft" @selected($p->status === 'draft')>
                                            Draft
                                        </option>
                                        <option value="menunggu_pembayaran" @selected($p->status === 'menunggu_pembayaran')>
                                            Menunggu Pembayaran
                                        </option>
                                        <option value="diproses" @selected($p->status === 'diproses')>
                                            Diproses
                                        </option>
                                    </select>
                                </form>
                            </td>

                            <td class="px-4 py-3 text-right font-bold text-blue-600">
                                Rp {{ number_format($p->total_harga, 0, ',', '.') }}
                            </td>

                            <td class="px-4 py-3">
                                <div class="flex justify-center gap-2">
                                    <a href="{{ route('penjualan.show', $p) }}"
                                        class="px-3 py-1 bg-blue-600 text-white rounded text-xs">
                                        Detail
                                    </a>
                                    <a href="{{ route('penjualan.edit', $p) }}"
                                        class="px-3 py-1 bg-amber-500 text-white rounded text-xs">
                                        Edit
                                    </a>
                                    <form action="{{ route('penjualan.destroy', $p) }}" method="POST"
                                        onsubmit="return confirm('Yakin hapus penjualan ini?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="px-3 py-1 bg-red-600 text-white rounded text-xs">
                                            Hapus
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        {{-- PAGINATION --}}
        <div class="mt-2">
            {{ $penjualan->links() }}
        </div>
    </div>

    {{-- ===================== --}}
    {{-- FLOATING ACTION BUTTON (MOBILE) --}}
    {{-- ===================== --}}
    <a href="{{ route('penjualan.create') }}" id="fab"
        class="fixed
          right-6
          bottom-24
          md:hidden
          z-40
          flex items-center justify-center
          w-14 h-14 rounded-full
          bg-blue-600 text-white
          shadow-xl
          transition-all duration-300 ease-out">

        <svg xmlns="http://www.w3.org/2000/svg" class="w-7 h-7" fill="none" viewBox="0 0 24 24"
            stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
        </svg>
    </a>
</x-app-layout>
<script>
    function searchForm() {
        return {
            beforeSubmit() {
                // simpan posisi scroll sebelum submit
                sessionStorage.setItem('scrollY', window.scrollY)
                sessionStorage.setItem('isSearching', '1')
            }
        }
    }

    document.addEventListener('DOMContentLoaded', () => {
        // restore scroll
        const scrollY = sessionStorage.getItem('scrollY')
        if (scrollY !== null) {
            window.scrollTo({
                top: parseInt(scrollY),
                behavior: 'instant'
            })
            sessionStorage.removeItem('scrollY')
        }

        // bersihkan flag searching
        sessionStorage.removeItem('isSearching')
    })
</script>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const header = document.querySelector('header');

        if (!header) return;

        const onScroll = () => {
            if (window.scrollY > 8) {
                header.classList.add('is-scrolled');
            } else {
                header.classList.remove('is-scrolled');
            }
        };

        window.addEventListener('scroll', onScroll, {
            passive: true
        });
        onScroll(); // initial check
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const fab = document.getElementById('fab');
        if (!fab) return;

        let lastScrollY = window.scrollY;
        let ticking = false;

        const updateFab = () => {
            const currentScrollY = window.scrollY;

            if (currentScrollY > lastScrollY + 10) {
                // scroll DOWN → hide
                fab.classList.add('fab-hide');
            } else if (currentScrollY < lastScrollY - 10) {
                // scroll UP → show
                fab.classList.remove('fab-hide');
            }

            lastScrollY = currentScrollY;
            ticking = false;
        };

        window.addEventListener('scroll', () => {
            if (!ticking) {
                window.requestAnimationFrame(updateFab);
                ticking = true;
            }
        }, {
            passive: true
        });
    });
</script>
