@section('title', 'Detail Penjualan')

<x-app-layout>
    {{-- ===================== --}}
    {{-- HEADER --}}
    {{-- ===================== --}}
    <x-slot name="header">
        <h2 class="text-xl font-semibold">
            Detail Penjualan
        </h2>
    </x-slot>

    {{-- ===================== --}}
    {{-- CONTENT --}}
    {{-- ===================== --}}
    <div class="p-4 max-w-3xl mx-auto space-y-6">

        {{-- ===================== --}}
        {{-- SECTION 1: INFO TRANSAKSI --}}
        {{-- ===================== --}}
        <div class="bg-white rounded-xl shadow border p-4 space-y-3">

            <h3 class="text-sm font-semibold text-gray-700">
                Informasi Transaksi
            </h3>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 text-sm">

                <div>
                    <div class="text-gray-500">Invoice</div>
                    <div class="font-semibold">{{ $penjualan->invoice }}</div>
                </div>

                <div>
                    <div class="text-gray-500">Tanggal</div>
                    <div class="font-semibold">
                        {{ \Carbon\Carbon::parse($penjualan->tanggal)->translatedFormat('d M Y') }}
                    </div>
                </div>

                <div>
                    <div class="text-gray-500">Petugas</div>
                    <div class="font-semibold">
                        {{ $penjualan->user->name }}
                    </div>
                </div>

                <div>
                    <div class="text-gray-500">Status</div>
                    <span
                        class="inline-block px-3 py-1 rounded-full text-xs font-semibold
                        @if ($penjualan->status === 'draft')
                            bg-gray-100 text-gray-700
                        @elseif ($penjualan->status === 'menunggu_pembayaran')
                            bg-amber-100 text-amber-700
                        @elseif ($penjualan->status === 'diproses')
                            bg-blue-100 text-blue-700
                        @else
                            bg-green-100 text-green-700
                        @endif"
                    >
                        {{ strtoupper(str_replace('_', ' ', $penjualan->status)) }}
                    </span>
                </div>

            </div>
        </div>

        {{-- ===================== --}}
        {{-- SECTION 2: DETAIL BARANG --}}
        {{-- ===================== --}}
        <div class="bg-white rounded-xl shadow border p-4 space-y-4">

            <h3 class="text-sm font-semibold text-gray-700">
                Daftar Barang
            </h3>

            <div class="space-y-3">
                @foreach ($penjualan->details as $detail)
                    <div
                        class="flex items-center justify-between
                        bg-gray-50 border rounded-lg p-3"
                    >
                        <div class="space-y-1">
                            <div class="font-semibold text-gray-900">
                                {{ $detail->barang->nama_barang }}
                            </div>

                            <div class="text-xs text-gray-500">
                                Qty:
                                <span class="font-semibold text-gray-700">
                                    {{ $detail->qty }} {{ $detail->barang->satuan }}
                                </span>
                            </div>

                            <div class="text-xs text-gray-500">
                                Harga:
                                Rp {{ number_format($detail->harga, 0, ',', '.') }}
                            </div>
                        </div>

                        <div class="text-right">
                            <div class="text-xs text-gray-500">
                                Subtotal
                            </div>
                            <div class="font-bold text-blue-600">
                                Rp {{ number_format($detail->subtotal, 0, ',', '.') }}
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        {{-- ===================== --}}
        {{-- SECTION 3: TOTAL --}}
        {{-- ===================== --}}
        <div
            class="bg-green-600 text-white
            rounded-xl shadow p-4
            flex items-center justify-between"
        >
            <div class="text-sm opacity-90">
                Total Pembayaran
            </div>

            <div class="text-2xl font-bold">
                Rp {{ number_format($penjualan->total_harga, 0, ',', '.') }}
            </div>
        </div>

        {{-- ===================== --}}
        {{-- SECTION 4: ACTION --}}
        {{-- ===================== --}}
        <div class="grid grid-cols-2 gap-3 pt-2">

            <a
                href="{{ route('penjualan.index') }}"
                class="py-3 bg-gray-200 rounded-lg
                text-center font-semibold"
            >
                Kembali
            </a>

            <a
                href="{{ route('penjualan.edit', $penjualan) }}"
                class="py-3 bg-amber-500 text-white
                rounded-lg text-center font-semibold"
            >
                Edit Penjualan
            </a>

        </div>

    </div>
</x-app-layout>
