<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BarangController;
use App\Http\Controllers\PenjualanController;

/*
|--------------------------------------------------------------------------
| Public Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return view('welcome');
});

/*
|--------------------------------------------------------------------------
| Authenticated Routes (Admin & Staff)
|--------------------------------------------------------------------------
*/
Route::middleware(['auth', 'verified'])->group(function () {

    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

/*
|--------------------------------------------------------------------------
| Admin Only Routes
|--------------------------------------------------------------------------
*/
Route::middleware(['auth', 'is_admin'])->group(function () {
    Route::resource('barang', BarangController::class);
    Route::resource('penjualan', PenjualanController::class);
    Route::patch(
        '/penjualan/{penjualan}/status',
        [PenjualanController::class, 'updateStatus']
    )->name('penjualan.updateStatus');

    Route::get('/admin', function () {
        return 'Halo Admin 👋';
    });

    // nanti di sini:
    // Route::resource('barang', BarangController::class);
    // Route::resource('penjualan', PenjualanController::class);
});

require __DIR__ . '/auth.php';
